/*
	Aware.r -- Version 3.0
	
	Developer Technical Support Apple II Sample Code
	
	Copyright (c) 1990 by Apple Computer, Inc.
	All Rights Reserved.

	This file contains the definitions of the resources used by the
	network aware sample application.  Since this program runs
	under System Software 5.0, it makes heavy use of resources.
	
	Note that the use of resources makes it easy to change things
	such as menu titles and item names without having to change
	the program at all.
*/


/* Include the definition of standard Apple IIGS resource types */
/* {RIIGSIncludes}TypesIIGS.r */ 
#include "TypesIIGS.r" 



/*
	Define the contents of the About box.  Remember, it is a string
	passed to AlertWindow
*/
resource rAlertString (1) {
 "0\$19\$00\$A0\$00\$AA\$00\$E0\$01"		/* Custom window (19,160,170,480) */
 "\$00@"									/* No icon, "@" is separator */
 TBCenterJust
 TBForeColor TBColor1						/* draw title in red */
 "Aware 3.0"
 TBForeColor TBColor0						/* back to black */
 TBEndOfLine
 TBEndOfLine
 "A sample program to demonstrate network awareness."
 TBEndOfLine
 TBEndOfLine
 "by"
 TBEndOfLine
 "Mark Day"
 TBEndOfLine
 TBEndOfLine
 "Copyright Apple Computer, Inc."
 TBEndOfLine
 "All Rights Reserved"
 TBEndOfLine
 TBEndOfLine
 "Last run: *0"								/* *0 will substitute a string */
 "@^#6\$00"									/* end text, default button:"Continue" */
};



/*
	Dialog box when unable to saveConfig.
*/
resource rAlertString (2) {
 "5"										/* a standard window size */
 "4@"										/* caution icon, start text */
 TBEndOfLine
 "Error saving configuration"
 "@^#0\$00"									/* default button: OK */
};


/*
	Record used by StartUpTools to determine which tools to start up.
*/
resource rToolStartup (1) {
 mode640, /* master SCB */
 { 
        3,$0300,  /* misc tools */
        4,$0301,  /* quickdraw */
        5,$0302,  /* desk manager */
        6,$0300,  /* eventMgr */
/*      7,$0200,  /* scheduler */
/*      8,$0301,  /* sound tools */
/*      9,$0201,  /* ADB tools */
/*      10,$0202, /* SANE */
        11,$0200, /* int math */
        14,$0301, /* Window Manager */
        15,$0301, /* Menu Manager */
        16,$0301, /* Control Manager */
        18,$0301, /* QD Aux */
        19,$0300, /* print manager */
        20,$0301, /* LineEdit tool set */
        21,$0302, /* Dialog Manager */
        22,$0300, /* Scrap manager */
        23,$0301, /* standard file */
/*      25,$0104, /* NoteSynth */
/*      26,$0104, /* Note Seq */
        27,$0301, /* Font manager */
        28,$0301, /* list manager */
/*      29,$0101, /* ACE */
/*      32,$0103, /* Midi Tools */
        34,$0101  /* text edit */
 }
};



/*
	Menu definitions
*/
#define AppleMenuID $901
#define FileMenuID $902
#define EditMenuID $903

#define UndoID 250
#define CutID 251
#define CopyID 252
#define PasteID 253
#define ClearID 254
#define CloseID 255
#define AboutID 301
#define QuitID 302
#define LoadConfigID 303
#define SaveConfigID 304
#define DividerID 399						/* dimmed dividing line */



/*
	Define the menus in the system menu bar.
*/
resource rMenuBar (1) {
 {
	AppleMenuID,
	FileMenuID,
	EditMenuID
 };
};

/*
	Define the contents of the Apple menu.
*/
resource rMenu (AppleMenuID) {
 AppleMenuID,
 0xA000 + rmAllowCache,
 AppleMenuID,
 {
	AboutID,
	DividerID
	/* NDAs go here */
 };
};

/*
	Define the File menu
*/
resource rMenu (FileMenuID) {
 FileMenuID,
 0xA000 + rmAllowCache,
 FileMenuID,
 {
	LoadConfigID,
	SaveConfigID,
	CloseID,
	DividerID,
	QuitID 
 };
};

/*
	Define the Edit menu
*/
resource rMenu (EditMenuID) {
 EditMenuID,
 0xA000 + rmDisabled+rmAllowCache,
 EditMenuID,
 { 
	UndoID,
	DividerID,
	CutID,
	CopyID,
	PasteID,
	ClearID
 };
};

/*
	Define the dimmed divider item used in all the menus
*/
resource rMenuItem (DividerID) {
 DividerID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIDisabled,
 DividerID
};

/*
	Undo menu item
*/
resource rMenuItem (UndoID) {
 UndoID,
 "Z","z",
 0,
 RefIsResource*ItemTitleRefShift,
 UndoID
};

/*
	Cut menu item
*/
resource rMenuItem (CutID) {
 CutID,
 "X","x",
 0,
 RefIsResource*ItemTitleRefShift,
 CutID
};

/*
	Copy menu item
*/
resource rMenuItem (CopyID) {
 CopyID,
 "C","c",
 0,
 RefIsResource*ItemTitleRefShift,
 CopyID
};

/*
	Paste menu item
*/
resource rMenuItem (PasteID) {
 PasteID,
 "V","v",
 0,
 RefIsResource*ItemTitleRefShift,
 PasteID
};

/*
	Clear menu item
*/
resource rMenuItem (ClearID) {
 ClearID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 ClearID
};

/*
	Close menu item
*/
resource rMenuItem (CloseID) {
 CloseID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 CloseID
};

/*
	"About Aware..." menu item
*/
resource rMenuItem (AboutID) {
 AboutID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 AboutID
};

/*
	Quit menu item
*/
resource rMenuItem (QuitID) {
 QuitID,
 "Q","q",
 0,
 RefIsResource*ItemTitleRefShift,
 QuitID
};

/*
	"Load Configuration" menu item
*/
resource rMenuItem (LoadConfigID) {
 LoadConfigID,
 "L","l",
 0,
 RefIsResource*ItemTitleRefShift,
 LoadConfigID
};

/*
	"Save Configuration" menu item
*/
resource rMenuItem (SaveConfigID) {
 SaveConfigID,
 "S","s",
 0,
 RefIsResource*ItemTitleRefShift,
 SaveConfigID
};

/*
	Strings for menu titles and menu items
*/
resource rPString (AppleMenuID) {
 "@"
 };
resource rPString (FileMenuID) {
 "  File  "
 };
resource rPString (EditMenuID) {
 "  Edit  "
 };

resource rPString (DividerID) {
 "-"
 };
resource rPString (AboutID) {
 "About Aware..."
 };
resource rPString (QuitID) {
 "Quit"
 };
resource rPString (LoadConfigID) {
 "Load Configuration"
 };
resource rPString (SaveConfigID) {
 "Save Configuration"
 };
resource rPString (UndoID) {
 "Undo"
 };
resource rPString (CutID) {
 "Cut"
 };
resource rPString (CopyID) {
 "Copy"
 };
resource rPString (PasteID) {
 "Paste"
 };
resource rPString (ClearID) {
 "Clear"
 };
resource rPString (CloseID) {
 "Close"
 };
